<?php

namespace Payroll\Additional\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface;

class AdditionalAllowancePublicController extends BaseController
{
    // use AdditionalAllowanceWorkflow;

    /**
     * Constructor.
     *
     * @param type \Payroll\AdditionalAllowance\Interfaces\AdditionalAllowanceRepositoryInterface $additional_allowance
     *
     * @return type
     */
    public function __construct(AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->repository = $additional_allowance;
        parent::__construct();
    }

    /**
     * Show additional_allowance's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $additional_allowances = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        return $this->theme->of('additional::public.additional_allowance.index', compact('additional_allowances'))->render();
    }

    /**
     * Show additional_allowance.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $additional_allowance = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->theme->of('additional::public.additional_allowance.show', compact('additional_allowance'))->render();
    }

}
