<?php

namespace Payroll\Additional\Http\Controllers;

use App\Http\Controllers\UserController as BaseController;
use Form;
use Payroll\Additional\Http\Requests\AdditionalAllowanceRequest;
use Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface;
use Payroll\Additional\Models\AdditionalAllowance;

class AdditionalAllowanceUserController extends BaseController
{
    /**
     * Initialize additional_allowance controller.
     *
     * @param type AdditionalAllowanceRepositoryInterface $additional_allowance
     *
     * @return type
     */
    public function __construct(AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->repository = $additional_allowance;
        $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->pushCriteria(new \Payroll\Additional\Repositories\Criteria\AdditionalAllowanceUserCriteria());
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(AdditionalAllowanceRequest $request)
    {
        $additional_allowances = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        $this->theme->prependTitle(trans('additional::additional_allowance.names'));

        return $this->theme->of('additional::user.additional_allowance.index', compact('additional_allowances'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param AdditionalAllowance $additional_allowance
     *
     * @return Response
     */
    public function show(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        Form::populate($additional_allowance);

        return $this->theme->of('additional::user.additional_allowance.show', compact('additional_allowance'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(AdditionalAllowanceRequest $request)
    {

        $additional_allowance = $this->repository->newInstance([]);
        Form::populate($additional_allowance);

        $this->theme->prependTitle(trans('additional::additional_allowance.names'));
        return $this->theme->of('additional::user.additional_allowance.create', compact('additional_allowance'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(AdditionalAllowanceRequest $request)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $additional_allowance = $this->repository->create($attributes);

            return redirect(trans_url('/user/additional/additional_allowance'))
                -> with('message', trans('messages.success.created', ['Module' => trans('additional::additional_allowance.name')]))
                -> with('code', 201);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param AdditionalAllowance $additional_allowance
     *
     * @return Response
     */
    public function edit(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {

        Form::populate($additional_allowance);
        $this->theme->prependTitle(trans('additional::additional_allowance.names'));

        return $this->theme->of('additional::user.additional_allowance.edit', compact('additional_allowance'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param AdditionalAllowance $additional_allowance
     *
     * @return Response
     */
    public function update(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        try {
            $this->repository->update($request->all(), $additional_allowance->getRouteKey());

            return redirect(trans_url('/user/additional/additional_allowance'))
                ->with('message', trans('messages.success.updated', ['Module' => trans('additional::additional_allowance.name')]))
                ->with('code', 204);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        try {
            $this->repository->delete($additional_allowance->getRouteKey());
            return redirect(trans_url('/user/additional/additional_allowance'))
                ->with('message', trans('messages.success.deleted', ['Module' => trans('additional::additional_allowance.name')]))
                ->with('code', 204);

        } catch (Exception $e) {

            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);

        }
    }
}
