<?php

namespace Payroll\Additional\Http\Controllers;
use Litepie\Additional\Http\Requests\AdditionalAllowanceRequest;
use Litepie\Additional\Models\AdditionalAllowance;

trait AdditionalAllowanceWorkflow {
	
    /**
     * Workflow controller function for additional_allowance.
     *
     * @param Model   $additional_allowance
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance, $step)
    {

        try {

            $additional_allowance->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('additional::additional_allowance.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/additional_allowance/additional_allowance/' . $additional_allowance->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/additional_allowance/additional_allowance/' . $additional_allowance->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for additional_allowance.
     *
     * @param Model   $additional_allowance
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
    */

    public function getWorkflow(AdditionalAllowance $additional_allowance, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $additional_allowance->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('additional::additional_allowance.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('additional::admin.additional_allowance.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('additional::admin.additional_allowance.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage(). '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('additional::admin.additional_allowance.message', $data)->render();

        }

    }
}