<?php

namespace Payroll\Additional\Http\Controllers\Api;

use App\Http\Controllers\Api\PublicController as BaseController;
use Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface;
use Payroll\Additional\Repositories\Presenter\AdditionalAllowanceItemTransformer;

/**
 * Pubic API controller class.
 */
class AdditionalAllowancePublicController extends BaseController
{
    /**
     * Constructor.
     *
     * @param type \Payroll\AdditionalAllowance\Interfaces\AdditionalAllowanceRepositoryInterface $additional_allowance
     *
     * @return type
     */
    public function __construct(AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->repository = $additional_allowance;
        parent::__construct();
    }

    /**
     * Show additional_allowance's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $additional_allowances = $this->repository
            ->setPresenter('\\Payroll\\Additional\\Repositories\\Presenter\\AdditionalAllowanceListPresenter')
            ->scopeQuery(function($query){
                return $query->orderBy('id','DESC');
            })->paginate();

        $additional_allowances['code'] = 2000;
        return response()->json($additional_allowances)
                ->setStatusCode(200, 'INDEX_SUCCESS');
    }

    /**
     * Show additional_allowance.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $additional_allowance = $this->repository
            ->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        if (!is_null($additional_allowance)) {
            $additional_allowance         = $this->itemPresenter($module, new AdditionalAllowanceItemTransformer);
            $additional_allowance['code'] = 2001;
            return response()->json($additional_allowance)
                ->setStatusCode(200, 'SHOW_SUCCESS');
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }

    }
}
