<?php

namespace Payroll\Additional\Http\Controllers\Api;

use App\Http\Controllers\Api\UserController as BaseController;
use Payroll\Additional\Http\Requests\AdditionalAllowanceRequest;
use Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface;
use Payroll\Additional\Models\AdditionalAllowance;

/**
 * User API controller class.
 */
class AdditionalAllowanceUserController extends BaseController
{
    /**
     * Initialize additional_allowance controller.
     *
     * @param type AdditionalAllowanceRepositoryInterface $additional_allowance
     *
     * @return type
     */
    public function __construct(AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->repository = $additional_allowance;
        $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->pushCriteria(new \Payroll\Additional\Repositories\Criteria\AdditionalAllowanceUserCriteria());
        parent::__construct();
    }

    /**
     * Display a list of additional_allowance.
     *
     * @return json
     */
    public function index(AdditionalAllowanceRequest $request)
    {
        $additional_allowances  = $this->repository
            ->setPresenter('\\Payroll\\Additional\\Repositories\\Presenter\\AdditionalAllowanceListPresenter')
            ->scopeQuery(function($query){
                return $query->orderBy('id','DESC');
            })->all();
        $additional_allowances['code'] = 2000;
        return response()->json($additional_allowances) 
            ->setStatusCode(200, 'INDEX_SUCCESS');

    }

    /**
     * Display additional_allowance.
     *
     * @param Request $request
     * @param Model   AdditionalAllowance
     *
     * @return Json
     */
    public function show(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {

        if ($additional_allowance->exists) {
            $additional_allowance         = $additional_allowance->presenter();
            $additional_allowance['code'] = 2001;
            return response()->json($additional_allowance)
                ->setStatusCode(200, 'SHOW_SUCCESS');;
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }

    }

    /**
     * Show the form for creating a new additional_allowance.
     *
     * @param Request $request
     *
     * @return json
     */
    public function create(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        $additional_allowance         = $additional_allowance->presenter();
        $additional_allowance['code'] = 2002;
        return response()->json($additional_allowance)
            ->setStatusCode(200, 'CREATE_SUCCESS');
    }

    /**
     * Create new additional_allowance.
     *
     * @param Request $request
     *
     * @return json
     */
    public function store(AdditionalAllowanceRequest $request)
    {
        try {
            $attributes             = $request->all();
            $attributes['user_id']  = user_id('admin.api');
            $additional_allowance          = $this->repository->create($attributes);
            $additional_allowance          = $additional_allowance->presenter();
            $additional_allowance['code']  = 2004;

            return response()->json($additional_allowance)
                ->setStatusCode(201, 'STORE_SUCCESS');
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                'code'    => 4004,
            ])->setStatusCode(400, 'STORE_ERROR');
        }

    }

    /**
     * Show additional_allowance for editing.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return json
     */
    public function edit(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        if ($additional_allowance->exists) {
            $additional_allowance         = $additional_allowance->presenter();
            $additional_allowance['code'] = 2003;
            return response()-> json($additional_allowance)
                ->setStatusCode(200, 'EDIT_SUCCESS');;
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }
    }

    /**
     * Update the additional_allowance.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return json
     */
    public function update(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        try {

            $attributes = $request->all();

            $additional_allowance->update($attributes);
            $additional_allowance         = $additional_allowance->presenter();
            $additional_allowance['code'] = 2005;

            return response()->json($additional_allowance)
                ->setStatusCode(201, 'UPDATE_SUCCESS');


        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 4005,
            ])->setStatusCode(400, 'UPDATE_ERROR');

        }
    }

    /**
     * Remove the additional_allowance.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return json
     */
    public function destroy(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {

        try {

            $t = $additional_allowance->delete();

            return response()->json([
                'message'  => trans('messages.success.delete', ['Module' => trans('additional::additional_allowance.name')]),
                'code'     => 2006
            ])->setStatusCode(202, 'DESTROY_SUCCESS');

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 4006,
            ])->setStatusCode(400, 'DESTROY_ERROR');
        }
    }
}
