<?php

namespace Payroll\Additional\Policies;

use App\User;
use Payroll\Additional\Models\AdditionalAllowance;

class AdditionalAllowancePolicy
{

    /**
     * Determine if the given user can view the additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function view(User $user, AdditionalAllowance $additional_allowance)
    {
        if ($user->canDo('additional.additional_allowance.view') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.view') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $additional_allowance->user_id;
    }

    /**
     * Determine if the given user can create a additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function create(User $user)
    {
        return  $user->canDo('additional.additional_allowance.create');
    }

    /**
     * Determine if the given user can update the given additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function update(User $user, AdditionalAllowance $additional_allowance)
    {
        if ($user->canDo('additional.additional_allowance.update') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.update') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $additional_allowance->user_id;
    }

    /**
     * Determine if the given user can delete the given additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function destroy(User $user, AdditionalAllowance $additional_allowance)
    {
        if ($user->canDo('additional.additional_allowance.delete') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.delete') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $additional_allowance->user_id;
    }

    /**
     * Determine if the given user can verify the given additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function verify(User $user, AdditionalAllowance $additional_allowance)
    {
        if ($user->canDo('additional.additional_allowance.verify') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('additional.additional_allowance.verify') 
        && $user->is('manager')
        && $additional_allowance->user->parent_id == $user->id) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given additional_allowance.
     *
     * @param User $user
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool
     */
    public function approve(User $user, AdditionalAllowance $additional_allowance)
    {
        if ($user->canDo('additional.additional_allowance.approve') && $user->is('admin')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperUser()) {
            return true;
        }
    }
}
