<?php

namespace Payroll\Additional\Providers;

use Illuminate\Support\ServiceProvider;

class AdditionalServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../../../resources/views', 'additional');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../../../resources/lang', 'additional');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('additional', function ($app) {
            return $this->app->make('Payroll\Additional\Additional');
        });

        // Bind AdditionalAllowance to repository
        $this->app->bind(
            'Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface',
            \Payroll\Additional\Repositories\Eloquent\AdditionalAllowanceRepository::class
        );

        $this->app->register(\Payroll\Additional\Providers\AuthServiceProvider::class);
        $this->app->register(\Payroll\Additional\Providers\EventServiceProvider::class);
        $this->app->register(\Payroll\Additional\Providers\RouteServiceProvider::class);
        // $this->app->register(\Payroll\Additional\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['additional'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../../../config/config.php' => config_path('payroll/additional.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../../../resources/views' => base_path('resources/views/vendor/additional')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../../../resources/lang' => base_path('resources/lang/vendor/additional')], 'lang');

        // Publish migrations
        $this->publishes([__DIR__ . '/../../../../database/migrations/' => base_path('database/migrations')], 'migrations');

        // Publish seeds
        $this->publishes([__DIR__ . '/../../../../database/seeds/' => base_path('database/seeds')], 'seeds');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
