<?php

namespace Payroll\Additional\Providers;

use Litepie\Contracts\Workflow\Workflow as WorkflowContract;
use Litepie\Foundation\Support\Providers\WorkflowServiceProvider as ServiceProvider;

class WorkflowServiceProvider extends ServiceProvider
{
    /**
     * The validators mappings for the package.
     *
     * @var array
     */
    protected $validators = [
        
        // Bind AdditionalAllowance validator
        \Payroll\Additional\Models\AdditionalAllowance::class => \Payroll\Additional\Workflow\AdditionalAllowanceValidator::class,
    ];

    /**
     * The actions mappings for the package.
     *
     * @var array
     */
    protected $actions = [
        
        // Bind AdditionalAllowance actions
        \Payroll\Additional\Models\AdditionalAllowance::class => \Payroll\Additional\Workflow\AdditionalAllowanceAction::class,
    ];

    /**
     * The notifiers mappings for the package.
     *
     * @var array
     */
    protected $notifiers = [
       
        // Bind AdditionalAllowance notifiers
        \Payroll\Additional\Models\AdditionalAllowance::class => \Payroll\Additional\Workflow\AdditionalAllowanceNotifier::class,
    ];

    /**
     * Register any package workflow validation services.
     *
     * @param \Litepie\Contracts\Workflow\Workflow $workflow
     *
     * @return void
     */
    public function boot(WorkflowContract $workflow)
    {
        parent::registerValidators($workflow);
        parent::registerActions($workflow);
        parent::registerNotifiers($workflow);
    }
}
