<?php

namespace Payroll\Additional\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class AdditionalAllowanceItemTransformer extends TransformerAbstract
{
    public function transform(\Payroll\Additional\Models\AdditionalAllowance $additional_allowance)
    {
        return [
            'id'                => $additional_allowance->getRouteKey(),
            'id'                => $additional_allowance->id,
            'company_id'        => $additional_allowance->company_id,
            'department_id'     => $additional_allowance->department_id,
            'employee_id'       => $additional_allowance->employee_id,
            'year'              => $additional_allowance->year,
            'month'             => $additional_allowance->month,
            'head'              => $additional_allowance->head,
            'amount'            => $additional_allowance->amount,
            'remarks'           => $additional_allowance->remarks,
            'created_at'        => $additional_allowance->created_at,
            'updated_at'        => $additional_allowance->updated_at,
            'deleted_at'        => $additional_allowance->deleted_at,
            'status'            => trans('app.'.$additional_allowance->status),
            'created_at'        => format_date($additional_allowance->created_at),
            'updated_at'        => format_date($additional_allowance->updated_at),
        ];
    }
}