<?php

namespace Payroll\Additional\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Payroll\Additional\Models\AdditionalAllowance;

class AdditionalAllowanceAction
{
    /**
     * Perform the complete action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */
    public function complete(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'complete';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */public function verify(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'verify';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */public function approve(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'approve';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */public function publish(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'publish';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */
    public function archive(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'archive';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return AdditionalAllowance
     */
    public function unpublish(AdditionalAllowance $additional_allowance)
    {
        try {
            $additional_allowance->status = 'unpublish';
            return $additional_allowance->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
