<?php

namespace Payroll\Additional\Workflow;

use Payroll\Additional\Models\AdditionalAllowance;
use Payroll\Additional\Notifications\AdditionalAllowance as AdditionalAllowanceNotifyer;
use Notification;

class AdditionalAllowanceNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function complete(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function verify(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function approve(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function publish(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function archive(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return void
     */
    public function unpublish(AdditionalAllowance $additional_allowance)
    {
        return Notification::send($additional_allowance->user, new AdditionalAllowanceNotifyer($additional_allowance, 'unpublish'));;

    }
}
