<?php

namespace Payroll\Additional\Workflow;

use Payroll\Additional\Models\AdditionalAllowance;
use Validator;

class AdditionalAllowanceValidator
{

    /**
     * Determine if the given additional_allowance is valid for complete status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function complete(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given additional_allowance is valid for verify status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function verify(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given additional_allowance is valid for approve status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function approve(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given additional_allowance is valid for publish status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function publish(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given additional_allowance is valid for archive status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function archive(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given additional_allowance is valid for unpublish status.
     *
     * @param AdditionalAllowance $additional_allowance
     *
     * @return bool / Validator
     */
    public function unpublish(AdditionalAllowance $additional_allowance)
    {
        return Validator::make($additional_allowance->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
