<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'admin',

    /*
     * Package.
     */
    'package'   => 'admin',

    /*
     * Modules.
     */
    'modules'   => ['user'],

    
    'user'       => [
        'model' => [
            'model'                 => \Admin\Admin\Models\User::class,
            'table'                 => 'users',
            'presenter'             => \Admin\Admin\Repositories\Presenter\UserPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'uname',  'pwd',  'name'],
            'translatables'         => [],
            'upload_folder'         => 'admin/user',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Admin',
            'package'   => 'Admin',
            'module'    => 'User',
        ],

    ],
];
