<?php

namespace Admin\Admin\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class UserTransformer extends TransformerAbstract
{
    public function transform(\Admin\Admin\Models\User $user)
    {
        return [
            'id'                => $user->getRouteKey(),
            'key'               => [
                'public'    => $user->getPublicKey(),
                'route'     => $user->getRouteKey(),
            ], 
            'id'                => $user->id,
            'uname'             => $user->uname,
            'pwd'               => $user->pwd,
            'name'              => $user->name,
            'url'               => [
                'public'    => trans_url('admin/'.$user->getPublicKey()),
                'user'      => guard_url('admin/user/'.$user->getRouteKey()),
            ], 
            'status'            => trans('app.'.$user->status),
            'created_at'        => format_date($user->created_at),
            'updated_at'        => format_date($user->updated_at),
        ];
    }
}