Lavalite package that provides alaska_airline management facility for the cms.

## Installation

Run the below command form the root folder of lavalite.

```
    composer require "me/alaska_airline"
```


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Me\\AlaskaAirline\\Seeders\\AlaskaAirlineTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Me\AlaskaAirline\Providers\AlaskaAirlineServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Me\AlaskaAirline\Providers\AlaskaAirlineServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Me\AlaskaAirline\Providers\AlaskaAirlineServiceProvider" --tag="view"
```


## URLs and APIs


### Web Urls

* Admin
```
    http://path-to-route-folder/admin/alaska_airline/{modulename}
```

* User
```
    http://path-to-route-folder/user/alaska_airline/{modulename}
```

* Public
```
    http://path-to-route-folder/alaska_airlines
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/alaska_airline/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/alaska_airline/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/alaska_airline/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
