<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateAnnotatorsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: annotators
         */
        Schema::create('annotators', function ($table) {
            $table->increments('id');
            $table->package::package.fieldtype.VARCHAR('user_id')->nullable();
            $table->package::package.fieldtype.VARCHAR('cv')->nullable();
            $table->package::package.fieldtype.VARCHAR('nativity')->nullable();
            $table->package::package.fieldtype.VARCHAR('seniority')->nullable();
            $table->package::package.fieldtype.DATETIME('modified_at')->nullable();
            $table->package::package.fieldtype.ON(')')->nullable();
            $table->package::package.fieldtype.PRIMARY('),')->nullable();
            $table->package::package.fieldtype.INDEX('id),')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('annotators');
    }
}
