<?php

namespace Annotators\Annotator\Seeders;

use DB;
use Illuminate\Database\Seeder;

class AnnotatorTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('annotators')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'annotator.annotator.view',
                'name'      => 'View Annotator',
            ],
            [
                'slug'      => 'annotator.annotator.create',
                'name'      => 'Create Annotator',
            ],
            [
                'slug'      => 'annotator.annotator.edit',
                'name'      => 'Update Annotator',
            ],
            [
                'slug'      => 'annotator.annotator.delete',
                'name'      => 'Delete Annotator',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/annotator/annotator',
                'name'        => 'Annotator',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/annotator/annotator',
                'name'        => 'Annotator',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'annotator',
                'name'        => 'Annotator',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Annotator',
                'module'    => 'Annotator',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'annotator.annotator.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
