# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/annotators/annotator/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Annotators\\Annotator\\": "packages/annotators/annotator/src",
            "Annotators\\Annotator\\Seeders\\": "packages/annotators/annotator/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Annotators\Annotator\Providers\AnnotatorServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Annotator'  => Annotators\Annotator\Facades\Annotator::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Annotators\\Annotator\\Seeders\\AnnotatorTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/annotator/{modulename}

**User**

    http://path-to-route-folder/user/annotator/{modulename}

**Public**

    http://path-to-route-folder/annotators


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/annotator/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/annotator/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/annotator/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/annotator/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/annotator/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/annotator/{modulename}/{slug}
    METHOD: GET