Lavalite package that provides annotator management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `annotators/annotator`.

    "annotators/annotator": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Annotators\Annotator\Providers\AnnotatorServiceProvider::class,

And also add it to alias

    'Annotator'  => Annotators\Annotator\Facades\Annotator::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Annotators\\Annotator\\Seeders\\AnnotatorTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Annotators\Annotator\Providers\AnnotatorServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/annotator/{modulename}

**User**

    http://path-to-route-folder/user/annotator/{modulename}

**Public**

    http://path-to-route-folder/annotators


### API endpoints

**List**

    http://path-to-route-folder/api/user/annotator/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/annotator/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/annotator/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/annotator/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/annotator/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/annotator/{modulename}/{slug}
    METHOD: GET