<?php

namespace Annotators\Annotator\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AnnotatorResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('annotator/annotator') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'user_id' => $this->user_id,
            'cv' => $this->cv,
            'nativity' => $this->nativity,
            'seniority' => $this->seniority,
            'modified_at' => $this->modified_at,
            ')' => $this->),
            '),' => $this->),,
            'id),' => $this->id),,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
