<?php

namespace Annotators\Annotator\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Litepie\Database\Model;
use Litepie\Database\Traits\Sluggable;
use Litepie\Database\Traits\Sortable;
use Litepie\Filer\Traits\Filer;
use Litepie\Hashids\Traits\Hashids;
use Litepie\Database\Traits\Scopable;
use Litepie\Trans\Traits\Translatable;

class Annotator extends Model
{
    use Filer;
    use Hashids;
    use Sluggable;
    use SoftDeletes;
    use Sortable;
    use Translatable;
    use Scopable;

    /**
     * Configuartion for the model.
     *
     * @var array
     */
     protected $config = 'annotators.annotator.annotator.model';


    /**
     * The array of searchable fields.
     * 
     * @var array
     */
    public $search = 'annotators.annotator.annotator.model.search';


}
