<?php

namespace Annotators\Annotator\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Annotators\Annotator\Models\Annotator;

class AnnotatorPolicy
{

    /**
     * Determine if the given user can view the annotator.
     *
     * @param UserPolicyInterface $authUser
     * @param Annotator $annotator
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Annotator $annotator)
    {
        if ($authUser->canDo('annotator.annotator.view') && $authUser->isAdmin()) {
            return true;
        }

        return $annotator->user_id == user_id() && $annotator->user_type == user_type();
    }

    /**
     * Determine if the given user can create a annotator.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('annotator.annotator.create');
    }

    /**
     * Determine if the given user can update the given annotator.
     *
     * @param UserPolicyInterface $authUser
     * @param Annotator $annotator
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Annotator $annotator)
    {
        if ($authUser->canDo('annotator.annotator.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $annotator->user_id == user_id() && $annotator->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given annotator.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Annotator $annotator)
    {
        return $annotator->user_id == user_id() && $annotator->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given annotator.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Annotator $annotator)
    {
        if ($authUser->canDo('annotator.annotator.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given annotator.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Annotator $annotator)
    {
        if ($authUser->canDo('annotator.annotator.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
