<?php

namespace Annotators\Annotator\Providers;

use Illuminate\Support\ServiceProvider;
use Annotators\Annotator\Annotators;

class AnnotatorServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'annotator');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'annotator');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        // $this->registerCommands();

        $this->app->register(\Annotators\Annotator\Providers\AuthServiceProvider::class);
        $this->app->register(\Annotators\Annotator\Providers\RouteServiceProvider::class);
        // $this->app->register(\Annotators\Annotator\Providers\EventServiceProvider::class);
        // $this->app->register(\Annotators\Annotator\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('annotators.annotator', function($app)
        {
            return $this->app->make(Annotators::class);
        });
    }



    /**
     * Merges user's and annotator's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'annotators.annotator'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/annotator.php', 'annotators.annotator.annotator'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Annotators\Annotator\Commands\Annotator::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['annotators.annotator'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('annotators/annotator')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/annotator')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/annotator')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
