<?php

namespace Zing\Bandwidth\Seeders;

use DB;
use Illuminate\Database\Seeder;

class BandwidthTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bandwidths')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bandwidth.bandwidth.view',
                'name'      => 'View Bandwidth',
            ],
            [
                'slug'      => 'bandwidth.bandwidth.create',
                'name'      => 'Create Bandwidth',
            ],
            [
                'slug'      => 'bandwidth.bandwidth.edit',
                'name'      => 'Update Bandwidth',
            ],
            [
                'slug'      => 'bandwidth.bandwidth.delete',
                'name'      => 'Delete Bandwidth',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/bandwidth/bandwidth',
                'name'        => 'Bandwidth',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/bandwidth/bandwidth',
                'name'        => 'Bandwidth',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'bandwidth',
                'name'        => 'Bandwidth',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Bandwidth',
                'module'    => 'Bandwidth',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bandwidth.bandwidth.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
