# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/zing/bandwidth/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Zing\\Bandwidth\\": "packages/zing/bandwidth/src",
            "Zing\\Bandwidth\\Seeders\\": "packages/zing/bandwidth/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Zing\Bandwidth\Providers\BandwidthServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Bandwidth'  => Zing\Bandwidth\Facades\Bandwidth::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Zing\\Bandwidth\\Seeders\\BandwidthTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/bandwidth/{modulename}

**User**

    http://path-to-route-folder/user/bandwidth/{modulename}

**Public**

    http://path-to-route-folder/bandwidths


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/bandwidth/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/bandwidth/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/bandwidth/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/bandwidth/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/bandwidth/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/bandwidth/{modulename}/{slug}
    METHOD: GET