Lavalite package that provides bandwidth management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `zing/bandwidth`.

    "zing/bandwidth": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Zing\Bandwidth\Providers\BandwidthServiceProvider::class,

And also add it to alias

    'Bandwidth'  => Zing\Bandwidth\Facades\Bandwidth::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Zing\\Bandwidth\\Seeders\\BandwidthTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Zing\Bandwidth\Providers\BandwidthServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/bandwidth/{modulename}

**User**

    http://path-to-route-folder/user/bandwidth/{modulename}

**Public**

    http://path-to-route-folder/bandwidths


### API endpoints

**List**

    http://path-to-route-folder/api/user/bandwidth/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/bandwidth/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/bandwidth/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/bandwidth/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/bandwidth/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/bandwidth/{modulename}/{slug}
    METHOD: GET