<?php

namespace Zing\Bandwidth\Forms;

use Litepie\Form\FormInterpreter;

class Bandwidth extends FormInterpreter
{

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public static function setAttributes()
    {

        self::$urls = [
            'new' => [
                'url' => guard_url('bandwidth/bandwidth/new'),
                'method' => 'GET',
            ],
            'create' => [
                'url' => guard_url('bandwidth/bandwidth/create'),
                'method' => 'GET',
            ],
            'store' => [
                'url' => guard_url('bandwidth/bandwidth'),
                'method' => 'POST',
            ],
            'update' => [
                'url' => guard_url('bandwidth/bandwidth'),
                'method' => 'PUT',
            ],
            'list' => [
                'url' => guard_url('bandwidth/bandwidth'),
                'method' => 'GET',
            ],
            'delete' => [
                'url' => guard_url('bandwidth/bandwidth'),
                'method' => 'DELETE',
            ],
        ];
        self::$search = [
            'name' => [
                "type" => 'text',
                "label" => trans('bandwidth::bandwidth.label.name'),
                "placeholder" => trans('bandwidth::bandwidth.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "4",
                "roles" => [],
            ]
        ];
        self::$orderBy = [
            'created_at' => trans('bandwidth::bandwidth.label.created_at'),
            'name' => trans('bandwidth::bandwidth.label.name'),
            'status' => trans('bandwidth::bandwidth.label.status'),
        ];
        self::$groups = [
            'main' => trans('bandwidth::bandwidth.groups.main'),
            'details' => trans('bandwidth::bandwidth.groups.details'),
            'images' => trans('bandwidth::bandwidth.groups.images'),
            'settings' => trans('bandwidth::bandwidth.groups.settings'),
        ];
        self::$list = [
            [
                'key' => "ref",
                'label' => trans('bandwidth::bandwidth.label.ref'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "id",
                'label' => trans('bandwidth::bandwidth.label.id'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "name",
                'label' => trans('bandwidth::bandwidth.label.name'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "status",
                'label' => trans('bandwidth::bandwidth.label.status'),
                'sortable' => 'true',
                'roles' => [],
            ],
        ];
        self::$fields = [
                
        ];

        return new static();
    }
}
