<?php

namespace Zing\Bandwidth\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Repository\Filter\RequestFilter;

use Zing\Bandwidth\Interfaces\BandwidthRepositoryInterface;
use Zing\Bandwidth\Repositories\Eloquent\Filters\BandwidthPublicFilter;
use Zing\Bandwidth\Repositories\Eloquent\Presenters\BandwidthListPresenter;

class BandwidthPublicController extends BaseController
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct(
        BandwidthRepositoryInterface $bandwidth
    ) {
        parent::__construct();
        $this->modules = $this->modules(config('zing.bandwidth.modules'), 'bandwidth', guard_url('bandwidth'));
        $this->repository = $bandwidth;
    }

    /**
     * Show bandwidth's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $data = $this->repository
            ->pushFilter(RequestFilter::class)
            ->pushFilter(BandwidthPublicFilter::class)
            ->setPresenter(BandwidthListPresenter::class)
            ->select('bandwidths.*')
            ->paginate($pageLimit)
            ->withQueryString()
            ->toArray();

        extract($data);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('bandwidth::bandwidth.names'))
            ->view('bandwidth::public.bandwidth.index')
            ->data(compact('data', 'meta', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show bandwidth.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $data = $this->repository
            ->findBySlug($slug)
            ->toArray();

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('bandwidth::bandwidth.name'))
            ->view('bandwidth::public.bandwidth.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
