<?php

namespace Zing\Bandwidth\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Zing\Bandwidth\Models\Bandwidth;

class BandwidthPolicy
{

    /**
     * Determine if the given user can view the bandwidth.
     *
     * @param UserPolicyInterface $authUser
     * @param Bandwidth $bandwidth
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Bandwidth $bandwidth)
    {
        if ($authUser->canDo('bandwidth.bandwidth.view') && $authUser->isAdmin()) {
            return true;
        }

        return $bandwidth->user_id == user_id() && $bandwidth->user_type == user_type();
    }

    /**
     * Determine if the given user can create a bandwidth.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('bandwidth.bandwidth.create');
    }

    /**
     * Determine if the given user can update the given bandwidth.
     *
     * @param UserPolicyInterface $authUser
     * @param Bandwidth $bandwidth
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Bandwidth $bandwidth)
    {
        if ($authUser->canDo('bandwidth.bandwidth.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $bandwidth->user_id == user_id() && $bandwidth->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given bandwidth.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Bandwidth $bandwidth)
    {
        return $bandwidth->user_id == user_id() && $bandwidth->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given bandwidth.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Bandwidth $bandwidth)
    {
        if ($authUser->canDo('bandwidth.bandwidth.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given bandwidth.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Bandwidth $bandwidth)
    {
        if ($authUser->canDo('bandwidth.bandwidth.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
