<?php

namespace Zing\Bandwidth\Providers;

use Illuminate\Support\ServiceProvider;
use Zing\Bandwidth\Bandwidths;

class BandwidthServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'bandwidth');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'bandwidth');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();

        $this->app->register(\Zing\Bandwidth\Providers\AuthServiceProvider::class);
        $this->app->register(\Zing\Bandwidth\Providers\RouteServiceProvider::class);
        // $this->app->register(\Zing\Bandwidth\Providers\EventServiceProvider::class);
        // $this->app->register(\Zing\Bandwidth\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('zing.bandwidth', function($app)
        {
            return $this->app->make(Bandwidths::class);
        });
    }

    /**
     * Register the bindings for the service provider.
     *
     * @return void
     */
    public function registerBindings() {
                // Bind Bandwidth to repository
        $this->app->bind(
            'Zing\Bandwidth\Interfaces\BandwidthRepositoryInterface',
            \Zing\Bandwidth\Repositories\Eloquent\BandwidthRepository::class
        );
    }


    /**
     * Merges user's and bandwidth's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'zing.bandwidth'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Zing\Bandwidth\Commands\Bandwidth::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['zing.bandwidth'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('zing/bandwidth.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/bandwidth')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/bandwidth')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
