<?php

namespace Zing\Bandwidth\Repositories\Eloquent;

use Zing\Bandwidth\Interfaces\BandwidthRepositoryInterface;
use Litepie\Repository\BaseRepository;
use Zing\Bandwidth\Repositories\Eloquent\Presenters\BandwidthItemPresenter;


class BandwidthRepository extends BaseRepository implements BandwidthRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('zing.bandwidth.bandwidth.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('zing.bandwidth.bandwidth.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return BandwidthItemPresenter::class;
    }
}
