<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'binary_tree_plan',

    /*
     * Modules.
     */
    'modules'   => ['binary_tree_plan', 'binary_tree_user'],

    'binary_tree_plan'       => [
        'model' => [
            'model'                 => \Litecms\BinaryTreePlan\Models\BinaryTreePlan::class,
            'table'                 => 'binary_tree_plans',
            'presenter'             => \Litecms\BinaryTreePlan\Repositories\Presenter\BinaryTreePlanPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name',  'price',  'value',  'percentage',  'point_left',  'point_right',  'status',  'added_by'],
            'translatables'         => [],
            'upload_folder'         => 'binary_tree_plan/binary_tree_plan',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'BinaryTreePlan',
            'module'    => 'BinaryTreePlan',
        ],

    ],
    'binary_tree_user'       => [
        'model' => [
            'model'                 => \Litecms\BinaryTreePlan\Models\BinaryTreeUser::class,
            'table'                 => 'binary_tree_users',
            'presenter'             => \Litecms\BinaryTreePlan\Repositories\Presenter\BinaryTreeUserPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['parent_id',  'child_id',  'level',  'leg',  'parent_plan_id',  'child_plan_id',  'point_status'],
            'translatables'         => [],
            'upload_folder'         => 'binary_tree_plan/binary_tree_user',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'BinaryTreePlan',
            'module'    => 'BinaryTreeUser',
        ],

    ],
];
