<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBinaryTreePlansTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: binary_tree_plans
         */
        Schema::create('binary_tree_plans', function ($table) {
            $table->increments('id');
            $table->string('name', 255)->nullable();
            $table->decimal('price', 50)->nullable();
            $table->integer('value')->nullable();
            $table->float('percentage')->nullable();
            $table->integer('point_left')->nullable();
            $table->integer('point_right')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->integer('added_by')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('binary_tree_plans');
    }
}
