<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBinaryTreeUsersTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: binary_tree_users
         */
        Schema::create('binary_tree_users', function ($table) {
            $table->increments('id');
            $table->integer('parent_id')->nullable();
            $table->integer('child_id')->nullable();
            $table->integer('level')->nullable();
            $table->enum('leg', [left,right])->nullable();
            $table->integer('parent_plan_id')->nullable();
            $table->integer('child_plan_id')->nullable();
            $table->string('point_status', 10)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('binary_tree_users');
    }
}
