<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Language files for binary_tree_user in binary_tree_plan package
    |--------------------------------------------------------------------------
    |
    | The following language lines are  for  binary_tree_user module in binary_tree_plan package
    | and it is used by the template/view files in this module
    |
    */

    /**
     * Singlular and plural name of the module
     */
    'name'          => 'BinaryTreeUser',
    'names'         => 'BinaryTreeUsers',
    
    /**
     * Singlular and plural name of the module
     */
    'title'         => [
        'main'  => 'BinaryTreeUsers',
        'sub'   => 'BinaryTreeUsers',
        'list'  => 'List of binary_tree_users',
        'edit'  => 'Edit binary_tree_user',
        'create'    => 'Create new binary_tree_user'
    ],

    /**
     * Options for select/radio/check.
     */
    'options'       => [
            'leg'                 => [left,right],
    ],

    /**
     * Placeholder for inputs
     */
    'placeholder'   => [
        'parent_id'                  => '',
        'child_id'                   => '',
        'level'                      => '',
        'leg'                        => '',
        'parent_plan_id'             => '',
        'child_plan_id'              => '',
        'point_status'               => '',
    ],

    /**
     * Labels for inputs.
     */
    'label'         => [
        'parent_id'                  => 'Select parent',
        'child_id'                   => 'Select child',
        'level'                      => 'Level',
        'leg'                        => 'Select leg',
        'parent_plan_id'             => 'Select parent plan',
        'child_plan_id'              => 'Select child plan',
        'point_status'               => '',
    ],

    /**
     * Columns array for show hide checkbox.
     */
    'cloumns'         => [
        'parent_id'                  => ['name' => 'Select parent', 'data-column' => 1, 'checked'],
        'child_id'                   => ['name' => 'Select child', 'data-column' => 2, 'checked'],
        'level'                      => ['name' => 'Level', 'data-column' => 3, 'checked'],
        'leg'                        => ['name' => 'Select leg', 'data-column' => 4, 'checked'],
        'parent_plan_id'             => ['name' => 'Select parent plan', 'data-column' => 5, 'checked'],
        'child_plan_id'              => ['name' => 'Select child plan', 'data-column' => 6, 'checked'],
    ],

    /**
     * Tab labels
     */
    'tab'           => [
        'name'  => 'BinaryTreeUsers',
    ],

    /**
     * Texts  for the module
     */
    'text'          => [
        'preview' => 'Click on the below list for preview',
    ],
];
