<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('binary_tree_plan::binary_tree_user.name') !!} <small> {!! trans('app.manage') !!} {!! trans('binary_tree_plan::binary_tree_user.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('binary_tree_plan::binary_tree_user.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='binary_tree_plan-binary_tree_user-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('binary_tree_plan/binary_tree_user')!!}">{!! trans('binary_tree_plan::binary_tree_user.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('binary_tree_plan/binary_tree_user?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('binary_tree_plan/binary_tree_user?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('binary_tree_plan/binary_tree_user/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('binary_tree_plan::admin.binary_tree_user.partial.actions')
                    -->
                    @include('binary_tree_plan::admin.binary_tree_user.partial.filter')
                    @include('binary_tree_plan::admin.binary_tree_user.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="binary_tree_plan-binary_tree_user-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="binary_tree_plan-binary_tree_user-check-all"></th>
                        <th data-field="parent_id">{!! trans('binary_tree_plan::binary_tree_user.label.parent_id')!!}</th>
                    <th data-field="child_id">{!! trans('binary_tree_plan::binary_tree_user.label.child_id')!!}</th>
                    <th data-field="level">{!! trans('binary_tree_plan::binary_tree_user.label.level')!!}</th>
                    <th data-field="leg">{!! trans('binary_tree_plan::binary_tree_user.label.leg')!!}</th>
                    <th data-field="parent_plan_id">{!! trans('binary_tree_plan::binary_tree_user.label.parent_plan_id')!!}</th>
                    <th data-field="child_plan_id">{!! trans('binary_tree_plan::binary_tree_user.label.child_plan_id')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#binary_tree_plan-binary_tree_user-entry', '{!!guard_url('binary_tree_plan/binary_tree_user/0')!!}');
    oTable = $('#binary_tree_plan-binary_tree_user-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('binary_tree_plan/binary_tree_user') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'parent_id'},
            {data :'child_id'},
            {data :'level'},
            {data :'leg'},
            {data :'parent_plan_id'},
            {data :'child_plan_id'},
        ],
        "pageLength": 25
    });

    $('#binary_tree_plan-binary_tree_user-list tbody').on( 'click', 'tr td:not(:first-child)', function (e) {
        e.preventDefault();

        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#binary_tree_plan-binary_tree_user-list').DataTable().row( this ).data();
        $('#binary_tree_plan-binary_tree_user-entry').load('{!!guard_url('binary_tree_plan/binary_tree_user')!!}' + '/' + d.id);
    });

    $('#binary_tree_plan-binary_tree_user-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#binary_tree_plan-binary_tree_user-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#binary_tree_plan-binary_tree_user-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#binary_tree_plan-binary_tree_user-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>