<?php

namespace Litecms\BinaryTreePlan\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\BinaryTreePlan\Http\Requests\BinaryTreePlanRequest;
use Litecms\BinaryTreePlan\Interfaces\BinaryTreePlanRepositoryInterface;
use Litecms\BinaryTreePlan\Models\BinaryTreePlan;

/**
 * Resource controller class for binary_tree_plan.
 */
class BinaryTreePlanResourceController extends BaseController
{

    /**
     * Initialize binary_tree_plan resource controller.
     *
     * @param type BinaryTreePlanRepositoryInterface $binary_tree_plan
     *
     * @return null
     */
    public function __construct(BinaryTreePlanRepositoryInterface $binary_tree_plan)
    {
        parent::__construct();
        $this->repository = $binary_tree_plan;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\BinaryTreePlan\Repositories\Criteria\BinaryTreePlanResourceCriteria::class);
    }

    /**
     * Display a list of binary_tree_plan.
     *
     * @return Response
     */
    public function index(BinaryTreePlanRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\BinaryTreePlan\Repositories\Presenter\BinaryTreePlanPresenter::class)
                ->$function();
        }

        $binary_tree_plans = $this->repository->paginate();

        return $this->response->title(trans('binary_tree_plan::binary_tree_plan.names'))
            ->view('binary_tree_plan::binary_tree_plan.index', true)
            ->data(compact('binary_tree_plans', 'view'))
            ->output();
    }

    /**
     * Display binary_tree_plan.
     *
     * @param Request $request
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function show(BinaryTreePlanRequest $request, BinaryTreePlan $binary_tree_plan)
    {

        if ($binary_tree_plan->exists) {
            $view = 'binary_tree_plan::binary_tree_plan.show';
        } else {
            $view = 'binary_tree_plan::binary_tree_plan.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('binary_tree_plan::binary_tree_plan.name'))
            ->data(compact('binary_tree_plan'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new binary_tree_plan.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(BinaryTreePlanRequest $request)
    {

        $binary_tree_plan = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('binary_tree_plan::binary_tree_plan.name')) 
            ->view('binary_tree_plan::binary_tree_plan.create', true) 
            ->data(compact('binary_tree_plan'))
            ->output();
    }

    /**
     * Create new binary_tree_plan.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(BinaryTreePlanRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $binary_tree_plan                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('binary_tree_plan::binary_tree_plan.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_plan/' . $binary_tree_plan->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/binary_tree_plan/binary_tree_plan'))
                ->redirect();
        }

    }

    /**
     * Show binary_tree_plan for editing.
     *
     * @param Request $request
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function edit(BinaryTreePlanRequest $request, BinaryTreePlan $binary_tree_plan)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('binary_tree_plan::binary_tree_plan.name'))
            ->view('binary_tree_plan::binary_tree_plan.edit', true)
            ->data(compact('binary_tree_plan'))
            ->output();
    }

    /**
     * Update the binary_tree_plan.
     *
     * @param Request $request
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function update(BinaryTreePlanRequest $request, BinaryTreePlan $binary_tree_plan)
    {
        try {
            $attributes = $request->all();

            $binary_tree_plan->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('binary_tree_plan::binary_tree_plan.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_plan/' . $binary_tree_plan->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('binary_tree_plan/binary_tree_plan/' . $binary_tree_plan->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the binary_tree_plan.
     *
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function destroy(BinaryTreePlanRequest $request, BinaryTreePlan $binary_tree_plan)
    {
        try {

            $binary_tree_plan->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('binary_tree_plan::binary_tree_plan.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_plan/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('binary_tree_plan/binary_tree_plan/' . $binary_tree_plan->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple binary_tree_plan.
     *
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function delete(BinaryTreePlanRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('binary_tree_plan::binary_tree_plan.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('binary_tree_plan/binary_tree_plan'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/binary_tree_plan/binary_tree_plan'))
                ->redirect();
        }

    }

    /**
     * Restore deleted binary_tree_plans.
     *
     * @param Model   $binary_tree_plan
     *
     * @return Response
     */
    public function restore(BinaryTreePlanRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('binary_tree_plan::binary_tree_plan.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/binary_tree_plan/binary_tree_plan'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/binary_tree_plan/binary_tree_plan/'))
                ->redirect();
        }

    }

}
