<?php

namespace Litecms\BinaryTreePlan\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\BinaryTreePlan\Http\Requests\BinaryTreeUserRequest;
use Litecms\BinaryTreePlan\Interfaces\BinaryTreeUserRepositoryInterface;
use Litecms\BinaryTreePlan\Models\BinaryTreeUser;

/**
 * Resource controller class for binary_tree_user.
 */
class BinaryTreeUserResourceController extends BaseController
{

    /**
     * Initialize binary_tree_user resource controller.
     *
     * @param type BinaryTreeUserRepositoryInterface $binary_tree_user
     *
     * @return null
     */
    public function __construct(BinaryTreeUserRepositoryInterface $binary_tree_user)
    {
        parent::__construct();
        $this->repository = $binary_tree_user;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\BinaryTreePlan\Repositories\Criteria\BinaryTreeUserResourceCriteria::class);
    }

    /**
     * Display a list of binary_tree_user.
     *
     * @return Response
     */
    public function index(BinaryTreeUserRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\BinaryTreePlan\Repositories\Presenter\BinaryTreeUserPresenter::class)
                ->$function();
        }

        $binary_tree_users = $this->repository->paginate();

        return $this->response->title(trans('binary_tree_plan::binary_tree_user.names'))
            ->view('binary_tree_plan::binary_tree_user.index', true)
            ->data(compact('binary_tree_users', 'view'))
            ->output();
    }

    /**
     * Display binary_tree_user.
     *
     * @param Request $request
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function show(BinaryTreeUserRequest $request, BinaryTreeUser $binary_tree_user)
    {

        if ($binary_tree_user->exists) {
            $view = 'binary_tree_plan::binary_tree_user.show';
        } else {
            $view = 'binary_tree_plan::binary_tree_user.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('binary_tree_plan::binary_tree_user.name'))
            ->data(compact('binary_tree_user'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new binary_tree_user.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(BinaryTreeUserRequest $request)
    {

        $binary_tree_user = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('binary_tree_plan::binary_tree_user.name')) 
            ->view('binary_tree_plan::binary_tree_user.create', true) 
            ->data(compact('binary_tree_user'))
            ->output();
    }

    /**
     * Create new binary_tree_user.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(BinaryTreeUserRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $binary_tree_user                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('binary_tree_plan::binary_tree_user.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_user/' . $binary_tree_user->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/binary_tree_plan/binary_tree_user'))
                ->redirect();
        }

    }

    /**
     * Show binary_tree_user for editing.
     *
     * @param Request $request
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function edit(BinaryTreeUserRequest $request, BinaryTreeUser $binary_tree_user)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('binary_tree_plan::binary_tree_user.name'))
            ->view('binary_tree_plan::binary_tree_user.edit', true)
            ->data(compact('binary_tree_user'))
            ->output();
    }

    /**
     * Update the binary_tree_user.
     *
     * @param Request $request
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function update(BinaryTreeUserRequest $request, BinaryTreeUser $binary_tree_user)
    {
        try {
            $attributes = $request->all();

            $binary_tree_user->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('binary_tree_plan::binary_tree_user.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_user/' . $binary_tree_user->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('binary_tree_plan/binary_tree_user/' . $binary_tree_user->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the binary_tree_user.
     *
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function destroy(BinaryTreeUserRequest $request, BinaryTreeUser $binary_tree_user)
    {
        try {

            $binary_tree_user->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('binary_tree_plan::binary_tree_user.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('binary_tree_plan/binary_tree_user/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('binary_tree_plan/binary_tree_user/' . $binary_tree_user->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple binary_tree_user.
     *
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function delete(BinaryTreeUserRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('binary_tree_plan::binary_tree_user.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('binary_tree_plan/binary_tree_user'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/binary_tree_plan/binary_tree_user'))
                ->redirect();
        }

    }

    /**
     * Restore deleted binary_tree_users.
     *
     * @param Model   $binary_tree_user
     *
     * @return Response
     */
    public function restore(BinaryTreeUserRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('binary_tree_plan::binary_tree_user.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/binary_tree_plan/binary_tree_user'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/binary_tree_plan/binary_tree_user/'))
                ->redirect();
        }

    }

}
