<?php

namespace Litecms\BinaryTreePlan\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Litepie\Database\Model;
use Litepie\Database\Traits\Slugger;
use Litepie\Filer\Traits\Filer;
use Litepie\Hashids\Traits\Hashids;
use Litepie\Repository\Traits\PresentableTrait;
use Litepie\Revision\Traits\Revision;
use Litepie\Trans\Traits\Translatable;
class BinaryTreeUser extends Model
{
    use Filer, SoftDeletes, Hashids, Slugger, Translatable, Revision, PresentableTrait;


    /**
     * Configuartion for the model.
     *
     * @var array
     */
     protected $config = 'litecms.binary_tree_plan.binary_tree_user.model';


    /**
     * The getchildplan that belong to the binary_tree_user.
     */
    public function getchildplan(){
        return $this->belongsTo('BinaryTreePlan\BinaryTreeUser\Models\BinaryTreePlan');
    }


    /**
     * The getparentplan that belong to the binary_tree_user.
     */
    public function getparentplan(){
        return $this->belongsTo('BinaryTreePlan\BinaryTreeUser\Models\BinaryTreePlan');
    }
}
