<?php

namespace Litecms\BinaryTreePlan\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BinaryTreePlan\Models\BinaryTreePlan;

class BinaryTreePlanPolicy
{

    /**
     * Determine if the given user can view the binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function view(UserPolicy $user, BinaryTreePlan $binary_tree_plan)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_plan.view') && $user->isAdmin()) {
            return true;
        }

        return $binary_tree_plan->user_id == user_id() && $binary_tree_plan->user_type == user_type();
    }

    /**
     * Determine if the given user can create a binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('binary_tree_plan.binary_tree_plan.create');
    }

    /**
     * Determine if the given user can update the given binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function update(UserPolicy $user, BinaryTreePlan $binary_tree_plan)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_plan.edit') && $user->isAdmin()) {
            return true;
        }

        return $binary_tree_plan->user_id == user_id() && $binary_tree_plan->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, BinaryTreePlan $binary_tree_plan)
    {
        return $binary_tree_plan->user_id == user_id() && $binary_tree_plan->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function verify(UserPolicy $user, BinaryTreePlan $binary_tree_plan)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_plan.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given binary_tree_plan.
     *
     * @param UserPolicy $user
     * @param BinaryTreePlan $binary_tree_plan
     *
     * @return bool
     */
    public function approve(UserPolicy $user, BinaryTreePlan $binary_tree_plan)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_plan.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
