<?php

namespace Litecms\BinaryTreePlan\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BinaryTreePlan\Models\BinaryTreeUser;

class BinaryTreeUserPolicy
{

    /**
     * Determine if the given user can view the binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function view(UserPolicy $user, BinaryTreeUser $binary_tree_user)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_user.view') && $user->isAdmin()) {
            return true;
        }

        return $binary_tree_user->user_id == user_id() && $binary_tree_user->user_type == user_type();
    }

    /**
     * Determine if the given user can create a binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('binary_tree_plan.binary_tree_user.create');
    }

    /**
     * Determine if the given user can update the given binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function update(UserPolicy $user, BinaryTreeUser $binary_tree_user)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_user.edit') && $user->isAdmin()) {
            return true;
        }

        return $binary_tree_user->user_id == user_id() && $binary_tree_user->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, BinaryTreeUser $binary_tree_user)
    {
        return $binary_tree_user->user_id == user_id() && $binary_tree_user->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function verify(UserPolicy $user, BinaryTreeUser $binary_tree_user)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_user.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given binary_tree_user.
     *
     * @param UserPolicy $user
     * @param BinaryTreeUser $binary_tree_user
     *
     * @return bool
     */
    public function approve(UserPolicy $user, BinaryTreeUser $binary_tree_user)
    {
        if ($user->canDo('binary_tree_plan.binary_tree_user.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
