<?php

namespace Litecms\BinaryTreePlan\Providers;

use Illuminate\Support\ServiceProvider;

class BinaryTreePlanServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'binary_tree_plan');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'binary_tree_plan');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerBinaryTreePlan();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerBinaryTreePlan()
    {
        $this->app->bind('binary_tree_plan', function($app) {
            return new BinaryTreePlan($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('BinaryTreePlan', 'Lavalite\BinaryTreePlan\Facades\BinaryTreePlan');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('litecms.binary_tree_plan', function ($app) {
            return $this->app->make('Litecms\BinaryTreePlan\BinaryTreePlan');
        });

        // Bind BinaryTreePlan to repository
        $this->app->bind(
            'Litecms\BinaryTreePlan\Interfaces\BinaryTreePlanRepositoryInterface',
            \Litecms\BinaryTreePlan\Repositories\Eloquent\BinaryTreePlanRepository::class
        );        // Bind BinaryTreeUser to repository
        $this->app->bind(
            'Litecms\BinaryTreePlan\Interfaces\BinaryTreeUserRepositoryInterface',
            \Litecms\BinaryTreePlan\Repositories\Eloquent\BinaryTreeUserRepository::class
        );

        $this->app->register(\Litecms\BinaryTreePlan\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\BinaryTreePlan\Providers\RouteServiceProvider::class);
            }

    /**
     * Merges user's and binary_tree_plan's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/binary_tree_plan.php', 'binary_tree_plan'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeBinaryTreePlan::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.binary_tree_plan'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/binary_tree_plan.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/binary_tree_plan')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/binary_tree_plan')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
