<?php

namespace Litecms\BinaryTreePlan\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Routing\Router;
use Litecms\BinaryTreePlan\Models\BinaryTreePlan;
use Request;
use Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to the controller routes in your routes file.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Litecms\BinaryTreePlan\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param   \Illuminate\Routing\Router  $router
     * @return void
     */
    public function boot()
    {
        parent::boot();

        if (Request::is('*/binary_tree_plan/binary_tree_plan/*')) {
            Route::bind('binary_tree_plan', function ($binary_tree_plan) {
                $binary_tree_planrepo = $this->app->make('Litecms\BinaryTreePlan\Interfaces\BinaryTreePlanRepositoryInterface');
                return $binary_tree_planrepo->findorNew($binary_tree_plan);
            });
        }
        if (Request::is('*/binary_tree_plan/binary_tree_user/*')) {
            Route::bind('binary_tree_user', function ($binary_tree_user) {
                $binary_tree_userrepo = $this->app->make('Litecms\BinaryTreePlan\Interfaces\BinaryTreeUserRepositoryInterface');
                return $binary_tree_userrepo->findorNew($binary_tree_user);
            });
        }

    }

    /**
     * Define the routes for the package.
     *
     * @return void
     */
    public function map()
    {
        $this->mapWebRoutes();
    }

    /**
     * Define the "web" routes for the package.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        if (request()->segment(1) == 'api' || request()->segment(2) == 'api') {
            return;
        }
        
        Route::group([
            'middleware' => 'web',
            'namespace'  => $this->namespace,
            'prefix'     => trans_setlocale(),
        ], function ($router) {
            require (__DIR__ . '/../../routes/web.php');
        });
    }

}
