<?php

namespace Litecms\BinaryTreePlan\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BinaryTreePlanTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BinaryTreePlan\Models\BinaryTreePlan $binary_tree_plan)
    {
        return [
            'id'                => $binary_tree_plan->getRouteKey(),
            'key'               => [
                'public'    => $binary_tree_plan->getPublicKey(),
                'route'     => $binary_tree_plan->getRouteKey(),
            ], 
            'name'              => $binary_tree_plan->name,
            'price'             => $binary_tree_plan->price,
            'value'             => $binary_tree_plan->value,
            'percentage'        => $binary_tree_plan->percentage,
            'point_left'        => $binary_tree_plan->point_left,
            'point_right'       => $binary_tree_plan->point_right,
            'status'            => $binary_tree_plan->status,
            'added_by'          => $binary_tree_plan->added_by,
            'url'               => [
                'public'    => trans_url('binary_tree_plan/'.$binary_tree_plan->getPublicKey()),
                'user'      => guard_url('binary_tree_plan/binary_tree_plan/'.$binary_tree_plan->getRouteKey()),
            ], 
            'status'            => trans('app.'.$binary_tree_plan->status),
            'created_at'        => format_date($binary_tree_plan->created_at),
            'updated_at'        => format_date($binary_tree_plan->updated_at),
        ];
    }
}