<?php

namespace Litecms\BinaryTreePlan\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BinaryTreeUserTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BinaryTreePlan\Models\BinaryTreeUser $binary_tree_user)
    {
        return [
            'id'                => $binary_tree_user->getRouteKey(),
            'key'               => [
                'public'    => $binary_tree_user->getPublicKey(),
                'route'     => $binary_tree_user->getRouteKey(),
            ], 
            'parent_id'         => $binary_tree_user->parent_id,
            'child_id'          => $binary_tree_user->child_id,
            'level'             => $binary_tree_user->level,
            'leg'               => $binary_tree_user->leg,
            'parent_plan_id'    => $binary_tree_user->parent_plan_id,
            'child_plan_id'     => $binary_tree_user->child_plan_id,
            'point_status'      => $binary_tree_user->point_status,
            'url'               => [
                'public'    => trans_url('binary_tree_plan/'.$binary_tree_user->getPublicKey()),
                'user'      => guard_url('binary_tree_plan/binary_tree_user/'.$binary_tree_user->getRouteKey()),
            ], 
            'status'            => trans('app.'.$binary_tree_user->status),
            'created_at'        => format_date($binary_tree_user->created_at),
            'updated_at'        => format_date($binary_tree_user->updated_at),
        ];
    }
}