<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'liteerp',

    /*
     * Package.
     */
    'package'   => 'branch',

    /*
     * Modules.
     */
    'modules'   => ['branch'],

    
    'branch'       => [
        'model' => [
            'model'                 => \Liteerp\Branch\Models\Branch::class,
            'table'                 => 'branches',
            'presenter'             => \Liteerp\Branch\Repositories\Presenter\BranchPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'company_id',  'name',  'email',  'password',  'status',  'api_token',  'remember_token',  'mobile',  'phone',  'address',  'street',  'city',  'district',  'state',  'country',  'photo',  'web',  'permissions',  'deleted_at',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'branch/branch',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Liteerp',
            'package'   => 'Branch',
            'module'    => 'Branch',
        ],

    ],
];
