<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: branches
         */
        Schema::create('branches', function ($table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->string('name', 100)->nullable();
            $table->string('email', 255)->nullable();
            $table->string('password', 100)->nullable();
            $table->enum('status', ['New','Active','Suspended'])->nullable();
            $table->string('api_token', 60)->nullable();
            $table->string('remember_token', 255)->nullable();
            $table->string('mobile', 100)->nullable();
            $table->string('phone', 100)->nullable();
            $table->string('address', 255)->nullable();
            $table->string('street', 100)->nullable();
            $table->string('city', 100)->nullable();
            $table->string('district', 100)->nullable();
            $table->string('state', 100)->nullable();
            $table->integer('country')->nullable();
            $table->string('photo', 500)->nullable();
            $table->string('web', 100)->nullable();
            $table->longText('permissions')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('branches');
    }
}
