<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Language files for branch in branch package
    |--------------------------------------------------------------------------
    |
    | The following language lines are  for  branch module in branch package
    | and it is used by the template/view files in this module
    |
    */

    /**
     * Singlular and plural name of the module
     */
    'name'          => 'Branch',
    'names'         => 'Branches',
    
    /**
     * Singlular and plural name of the module
     */
    'title'         => [
        'main'  => 'Branches',
        'sub'   => 'Branches',
        'list'  => 'List of branches',
        'edit'  => 'Edit branch',
        'create'    => 'Create new branch'
    ],

    /**
     * Options for select/radio/check.
     */
    'options'       => [
            'status'              => ['New','Active','Suspended'],
    ],

    /**
     * Placeholder for inputs
     */
    'placeholder'   => [
        'id'                         => 'Please enter id',
        'company_id'                 => 'Please enter company id',
        'name'                       => 'Please enter name',
        'email'                      => 'Please enter email',
        'password'                   => 'Please enter password',
        'status'                     => 'Please select status',
        'api_token'                  => 'Please enter api token',
        'remember_token'             => 'Please enter remember token',
        'mobile'                     => 'Please enter mobile',
        'phone'                      => 'Please enter phone',
        'address'                    => 'Please enter address',
        'street'                     => 'Please enter street',
        'city'                       => 'Please enter city',
        'district'                   => 'Please enter district',
        'state'                      => 'Please enter state',
        'country'                    => 'Please enter country',
        'photo'                      => 'Please enter photo',
        'web'                        => 'Please enter web',
        'permissions'                => 'Please enter permissions',
        'deleted_at'                 => 'Please select deleted at',
        'created_at'                 => 'Please select created at',
        'updated_at'                 => 'Please select updated at',
    ],

    /**
     * Labels for inputs.
     */
    'label'         => [
        'id'                         => 'Id',
        'company_id'                 => 'Company id',
        'name'                       => 'Name',
        'email'                      => 'Email',
        'password'                   => 'Password',
        'status'                     => 'Status',
        'api_token'                  => 'Api token',
        'remember_token'             => 'Remember token',
        'mobile'                     => 'Mobile',
        'phone'                      => 'Phone',
        'address'                    => 'Address',
        'street'                     => 'Street',
        'city'                       => 'City',
        'district'                   => 'District',
        'state'                      => 'State',
        'country'                    => 'Country',
        'photo'                      => 'Photo',
        'web'                        => 'Web',
        'permissions'                => 'Permissions',
        'deleted_at'                 => 'Deleted at',
        'created_at'                 => 'Created at',
        'updated_at'                 => 'Updated at',
    ],

    /**
     * Columns array for show hide checkbox.
     */
    'cloumns'         => [
        'company_id'                 => ['name' => 'Company id', 'data-column' => 1, 'checked'],
        'name'                       => ['name' => 'Name', 'data-column' => 2, 'checked'],
        'email'                      => ['name' => 'Email', 'data-column' => 3, 'checked'],
        'status'                     => ['name' => 'Status', 'data-column' => 4, 'checked'],
        'mobile'                     => ['name' => 'Mobile', 'data-column' => 5, 'checked'],
        'phone'                      => ['name' => 'Phone', 'data-column' => 6, 'checked'],
        'street'                     => ['name' => 'Street', 'data-column' => 7, 'checked'],
        'city'                       => ['name' => 'City', 'data-column' => 8, 'checked'],
        'district'                   => ['name' => 'District', 'data-column' => 9, 'checked'],
        'state'                      => ['name' => 'State', 'data-column' => 10, 'checked'],
        'country'                    => ['name' => 'Country', 'data-column' => 11, 'checked'],
        'web'                        => ['name' => 'Web', 'data-column' => 12, 'checked'],
    ],

    /**
     * Tab labels
     */
    'tab'           => [
        'name'  => 'Branches',
    ],

    /**
     * Texts  for the module
     */
    'text'          => [
        'preview' => 'Click on the below list for preview',
    ],
];
