<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('branch::branch.name') !!} <small> {!! trans('app.manage') !!} {!! trans('branch::branch.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('branch::branch.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='branch-branch-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('branch/branch')!!}">{!! trans('branch::branch.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('branch/branch?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('branch/branch?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('branch/branch/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('branch::admin.branch.partial.actions')
                    -->
                    @include('branch::admin.branch.partial.filter')
                    @include('branch::admin.branch.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="branch-branch-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="branch-branch-check-all"></th>
                        <th data-field="company_id">{!! trans('branch::branch.label.company_id')!!}</th>
                    <th data-field="name">{!! trans('branch::branch.label.name')!!}</th>
                    <th data-field="email">{!! trans('branch::branch.label.email')!!}</th>
                    <th data-field="status">{!! trans('branch::branch.label.status')!!}</th>
                    <th data-field="mobile">{!! trans('branch::branch.label.mobile')!!}</th>
                    <th data-field="phone">{!! trans('branch::branch.label.phone')!!}</th>
                    <th data-field="street">{!! trans('branch::branch.label.street')!!}</th>
                    <th data-field="city">{!! trans('branch::branch.label.city')!!}</th>
                    <th data-field="district">{!! trans('branch::branch.label.district')!!}</th>
                    <th data-field="state">{!! trans('branch::branch.label.state')!!}</th>
                    <th data-field="country">{!! trans('branch::branch.label.country')!!}</th>
                    <th data-field="web">{!! trans('branch::branch.label.web')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#branch-branch-entry', '{!!guard_url('branch/branch/0')!!}');
    oTable = $('#branch-branch-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('branch/branch') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'company_id'},
            {data :'name'},
            {data :'email'},
            {data :'status'},
            {data :'mobile'},
            {data :'phone'},
            {data :'street'},
            {data :'city'},
            {data :'district'},
            {data :'state'},
            {data :'country'},
            {data :'web'},
        ],
        "pageLength": 25
    });

    $('#branch-branch-list tbody').on( 'click', 'tr td:not(:first-child)', function (e) {
        e.preventDefault();

        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#branch-branch-list').DataTable().row( this ).data();
        $('#branch-branch-entry').load('{!!guard_url('branch/branch')!!}' + '/' + d.id);
    });

    $('#branch-branch-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#branch-branch-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#branch-branch-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#branch-branch-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>