<?php

namespace Liteerp\Branch;

use User;

class Branch
{
    /**
     * $branch object.
     */
    protected $branch;

    /**
     * Constructor.
     */
    public function __construct(\Liteerp\Branch\Interfaces\BranchRepositoryInterface $branch)
    {
        $this->branch = $branch;
    }

    /**
     * Returns count of branch.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.branch.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->branch->pushCriteria(new \Litepie\Liteerp\Repositories\Criteria\BranchUserCriteria());
        }

        $branch = $this->branch->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('branch::' . $view, compact('branch'))->render();
    }
}
